"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderQueueProcessor = void 0;
const bullmq_1 = require("@nestjs/bullmq");
const bullmq_2 = require("bullmq");
let OrderQueueProcessor = class OrderQueueProcessor extends bullmq_1.WorkerHost {
    async process(job) {
        console.log(`Processing job: ${job.id}`, job.data);
        const { orderId, email } = job.data;
        console.log(`📧 Sending order confirmation to ${email} for Order #${orderId}`);
        await new Promise((resolve) => setTimeout(resolve, 2000));
        console.log('✅ Email sent successfully!');
        return true;
    }
    onCompleted(job) {
        console.log(`🎉 Job ${job.id} completed successfully`);
    }
    onFailed(job, err) {
        console.error(`❌ Job ${job.id} failed:`, err.message);
    }
};
exports.OrderQueueProcessor = OrderQueueProcessor;
__decorate([
    (0, bullmq_1.OnWorkerEvent)('completed'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [bullmq_2.Job]),
    __metadata("design:returntype", void 0)
], OrderQueueProcessor.prototype, "onCompleted", null);
__decorate([
    (0, bullmq_1.OnWorkerEvent)('failed'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [bullmq_2.Job, Error]),
    __metadata("design:returntype", void 0)
], OrderQueueProcessor.prototype, "onFailed", null);
exports.OrderQueueProcessor = OrderQueueProcessor = __decorate([
    (0, bullmq_1.Processor)('order')
], OrderQueueProcessor);
//# sourceMappingURL=order-queue.processor.js.map